package com.ejie.ab04b.service;

import java.util.List;

import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.TramiteAperturas;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TramiteAperturasService generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

public interface TramiteAperturasService {

	/**
	 * Inserts a single row in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  TramiteAperturas
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @return the tramite aperturas
	 */
	TramiteAperturas add(TramiteAperturas tramiteAperturas);

	/**
	 * Updates a single row in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  TramiteAperturas
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @return the tramite aperturas
	 */
	TramiteAperturas update(TramiteAperturas tramiteAperturas);

	/**
	 * Finds a single row in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  TramiteAperturas
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @return the tramite aperturas
	 */
	TramiteAperturas find(TramiteAperturas tramiteAperturas);

	/**
	 * Finds a single row in the TramiteAperturas table.
	 * 
	 *  idTipoTramite
	 *            Long
	 *  apertura
	 *            ComunicacionApertura
	 *  TramiteAperturas
	 *
	 * @param idTipoTramite the id tipo tramite
	 * @param apertura the apertura
	 * @return the tramite aperturas
	 */
	public TramiteAperturas findLastTramiteByTipo(Long idTipoTramite,
			ComunicacionApertura apertura);

	/**
	 * Busca un trámite y le carga su lista de tareas asociadas.
	 * 
	 *  tramiteAperturas            TramiteAperturas
	 *  TramiteAperturas
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @return the tramite aperturas
	 */
	public TramiteAperturas findConTareas(TramiteAperturas tramiteAperturas);

	/**
	 * Deletes a single row in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *
	 * @param tramiteAperturas the tramite aperturas
	 */
	void remove(TramiteAperturas tramiteAperturas);

	/**
	 * Finds a list of rows in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TramiteAperturas>
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<TramiteAperturas> findAll(TramiteAperturas tramiteAperturas,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds a list of rows in the TramiteAperturas table.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  List<TramiteAperturas>
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @return the list
	 */
	public List<TramiteAperturas> findAllConTareas(
			TramiteAperturas tramiteAperturas);

	/**
	 * Finds rows in the TramiteAperturas table using like.
	 * 
	 *  tramiteAperturas
	 *            TramiteAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TramiteAperturas>
	 *
	 * @param tramiteAperturas the tramite aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TramiteAperturas> findAllLike(TramiteAperturas tramiteAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the TramiteAperturas table.
	 * 
	 *  filterTramiteAperturas
	 *            TramiteAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<TramiteAperturas>
	 *
	 * @param filterTramiteAperturas the filter tramite aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<TramiteAperturas> filter(
			TramiteAperturas filterTramiteAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the TramiteAperturas table.
	 * 
	 *  filterTramiteAperturas
	 *            TramiteAperturas
	 *  searchTramiteAperturas
	 *            TramiteAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<TramiteAperturas>>
	 *
	 * @param filterTramiteAperturas the filter tramite aperturas
	 * @param searchTramiteAperturas the search tramite aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<TramiteAperturas>> search(
			TramiteAperturas filterTramiteAperturas,
			TramiteAperturas searchTramiteAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in TramiteAperturas table.
	 * 
	 *  filterTramiteAperturas
	 *            TramiteAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterTramiteAperturas the filter tramite aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	Object reorderSelection(TramiteAperturas filterTramiteAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

}
